import { Card } from "@/components/ui/card";
import { Calculator, MapPin, HeadphonesIcon, Globe, Plane, Building } from "lucide-react";

const services = [
  {
    icon: Calculator,
    title: "Rate Calculator",
    description: "Get instant shipping rates for your packages",
  },
  {
    icon: MapPin,
    title: "Find Office",
    description: "Locate our offices and service points near you",
  },
  {
    icon: HeadphonesIcon,
    title: "Help and Support",
    description: "Get expert help from our support team",
  },
  {
    icon: Globe,
    title: "Global Network",
    description: "Ship to over 200 countries worldwide",
  },
  {
    icon: Plane,
    title: "Express Delivery",
    description: "Fast and reliable express shipping services",
  },
  {
    icon: Building,
    title: "Business Solutions",
    description: "Tailored logistics for your business needs",
  },
];

export const ServicesSection = () => {
  return (
    <section id="services" className="py-16 sm:py-24 bg-secondary/30">
      <div className="container mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-12">
          <h2 className="text-3xl font-bold tracking-tight text-foreground sm:text-4xl mb-4">
            Our Services
          </h2>
          <p className="text-lg text-muted-foreground max-w-2xl mx-auto">
            Comprehensive freight and logistics solutions to meet all your shipping needs
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          {services.map((service, index) => (
            <Card
              key={index}
              className="group p-6 hover:shadow-medium transition-all duration-300 hover:-translate-y-1 cursor-pointer border-border/50 hover:border-accent/50 animate-fade-in"
              style={{ animationDelay: `${index * 0.1}s` }}
            >
              <div className="mb-4 inline-flex items-center justify-center rounded-lg bg-accent/10 p-3 text-accent group-hover:bg-accent group-hover:text-accent-foreground transition-all duration-300">
                <service.icon className="h-6 w-6" />
              </div>
              <h3 className="text-xl font-semibold mb-2 text-foreground group-hover:text-accent transition-colors">
                {service.title}
              </h3>
              <p className="text-muted-foreground">{service.description}</p>
            </Card>
          ))}
        </div>
      </div>
    </section>
  );
};
