import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Search } from "lucide-react";
import { useState } from "react";
import { useToast } from "@/hooks/use-toast";

export const HeroSection = () => {
  const [trackingNumber, setTrackingNumber] = useState("");
  const { toast } = useToast();

  const handleTrack = () => {
    if (trackingNumber.trim()) {
      toast({
        title: "Tracking Shipment",
        description: `Looking up tracking number: ${trackingNumber}`,
      });
    }
  };

  return (
    <section id="track" className="relative overflow-hidden bg-gradient-hero py-20 sm:py-32">
      <div className="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNjAiIGhlaWdodD0iNjAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PGRlZnM+PHBhdHRlcm4gaWQ9ImdyaWQiIHdpZHRoPSI2MCIgaGVpZ2h0PSI2MCIgcGF0dGVyblVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+PHBhdGggZD0iTSAxMCAwIEwgMCAwIDAgMTAiIGZpbGw9Im5vbmUiIHN0cm9rZT0id2hpdGUiIHN0cm9rZS1vcGFjaXR5PSIwLjA1IiBzdHJva2Utd2lkdGg9IjEiLz48L3BhdHRlcm4+PC9kZWZzPjxyZWN0IHdpZHRoPSIxMDAlIiBoZWlnaHQ9IjEwMCUiIGZpbGw9InVybCgjZ3JpZCkiLz48L3N2Zz4=')] opacity-20"></div>
      
      <div className="container relative mx-auto px-4 sm:px-6 lg:px-8">
        <div className="mx-auto max-w-3xl text-center">
          <h1 className="mb-6 text-4xl font-bold tracking-tight text-primary-foreground sm:text-5xl md:text-6xl animate-fade-in">
            Track Your Shipment
          </h1>
          <p className="mb-8 text-lg text-primary-foreground/90 animate-fade-in" style={{ animationDelay: '0.1s' }}>
            Enter your tracking number to get real-time updates on your shipment
          </p>

          <div className="mx-auto max-w-2xl animate-fade-in" style={{ animationDelay: '0.2s' }}>
            <div className="flex flex-col gap-4 rounded-lg bg-background p-6 shadow-large sm:flex-row">
              <Input
                type="text"
                placeholder="Enter tracking number"
                value={trackingNumber}
                onChange={(e) => setTrackingNumber(e.target.value)}
                onKeyDown={(e) => e.key === 'Enter' && handleTrack()}
                className="flex-1 h-12"
              />
              <Button 
                onClick={handleTrack}
                size="lg"
                className="bg-accent text-accent-foreground hover:bg-accent/90 h-12"
              >
                <Search className="mr-2 h-5 w-5" />
                Track
              </Button>
            </div>
            <p className="mt-4 text-sm text-primary-foreground/70">
              Enter multiple tracking numbers separated by commas for bulk tracking
            </p>
          </div>
        </div>
      </div>
    </section>
  );
};
