import { Button } from "@/components/ui/button";
import { Package } from "lucide-react";

export const Header = () => {
  return (
    <header className="sticky top-0 z-50 w-full border-b border-border/40 bg-background/95 backdrop-blur supports-[backdrop-filter]:bg-background/60">
      <div className="container mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex h-16 items-center justify-between">
          <div className="flex items-center gap-2">
            <div className="flex items-center gap-2 text-primary">
              <Package className="h-8 w-8" />
              <span className="text-xl font-bold">Falcon Freight Arab</span>
            </div>
          </div>

          <nav className="hidden md:flex items-center gap-6">
            <a href="#track" className="text-sm font-medium text-foreground hover:text-accent transition-colors">
              Ship & Track
            </a>
            <a href="#services" className="text-sm font-medium text-foreground hover:text-accent transition-colors">
              Logistics Solutions
            </a>
            <a href="#contact" className="text-sm font-medium text-foreground hover:text-accent transition-colors">
              Contact
            </a>
            <a href="#about" className="text-sm font-medium text-foreground hover:text-accent transition-colors">
              About Us
            </a>
          </nav>

          <div className="flex items-center gap-3">
            <Button variant="outline" className="hidden sm:inline-flex">
              Get a Quote
            </Button>
            <Button className="bg-accent text-accent-foreground hover:bg-accent/90">
              Log In
            </Button>
          </div>
        </div>
      </div>
    </header>
  );
};
