import { Button } from "@/components/ui/button";
import { CheckCircle } from "lucide-react";

const highlights = [
  "Over 20 years of logistics excellence",
  "Global network spanning 200+ countries",
  "24/7 customer support",
  "Advanced tracking technology",
  "Competitive rates and reliable service",
];

export const AboutSection = () => {
  return (
    <section id="about" className="py-16 sm:py-24">
      <div className="container mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
          <div className="animate-fade-in">
            <h2 className="text-3xl font-bold tracking-tight text-foreground sm:text-4xl mb-6">
              About Falcon Freight Arab
            </h2>
            <p className="text-lg text-muted-foreground mb-6">
              As a leading logistics provider in the Arab region, we deliver comprehensive freight 
              forwarding and supply chain solutions. Our commitment to excellence and innovation 
              ensures your shipments arrive safely and on time.
            </p>
            <ul className="space-y-3 mb-8">
              {highlights.map((highlight, index) => (
                <li key={index} className="flex items-start gap-3">
                  <CheckCircle className="h-6 w-6 text-accent flex-shrink-0 mt-0.5" />
                  <span className="text-foreground">{highlight}</span>
                </li>
              ))}
            </ul>
            <div className="flex flex-wrap gap-4">
              <Button size="lg" className="bg-accent text-accent-foreground hover:bg-accent/90">
                Learn More
              </Button>
              <Button size="lg" variant="outline">
                Contact Us
              </Button>
            </div>
          </div>

          <div className="relative animate-fade-in" style={{ animationDelay: '0.2s' }}>
            <div className="aspect-[4/3] rounded-lg bg-gradient-to-br from-primary to-primary/80 shadow-large overflow-hidden">
              <div className="absolute inset-0 flex items-center justify-center">
                <div className="text-center text-primary-foreground p-8">
                  <div className="text-6xl font-bold mb-4">200+</div>
                  <div className="text-xl">Countries Served</div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};
